#!/bin/sh
# Maintained by: toleda for: github.com/toleda/audio_hdmi_8series
gFile="audio_hdmi_hd4600-hda-90_v2_patch.command_v2.0"
# Credit: pikeralpha, TimeWalker75a
#
# Desktop/Laptop HD4600 HDMI audio applehda edit
# Enables HD4600 HDMI audio, additional dsdt edits required
#
# NOTE: Run this patch file only once on a AppleHDA.kext
#
# Requirements
# 1. 10.9 or newer
# 2. Haswell/HD4600 Graphics
# 3. Device_ID: 8086 0c0c, patch not required with 0c0a or 0c0d.
# 4. S/L/E/AppleHDA_v2.5.2 or newer
#
# Installation
# 1. Downloads/audio_hdmi_hd5k-hda-90_v2_patch.command
# 2. Double click audio_hdmi_hd5k-hda-90_v2_patch.command
# 3. Enter password at prompt
#
echo "Agreement"
echo "The audio_hdmi_hd5k-hda_patch is for personal use only.  Do not distribute the"
echo "patch or the resulting patched AppleHDA.kext for any reason without permission."
echo "The audio_hdmi_hd5k-hda_patch is provided as is, without any kind of warranty."
#
# set initial variables
gSysVer=`sw_vers -productVersion`
gSysName="Mavericks"
gSysFolder="10.9"
gDesktopDirectory=/Users/$(whoami)/Desktop
gExtensionsDirectory=/System/Library/Extensions
gHDAContentsDirectory=$gExtensionsDirectory/AppleHDA.kext/Contents
gHDAControllerbinaryDirectory=$gHDAContentsDirectory/Plugins/AppleHDAController.kext/Contents/MacOS

#verify system version
case ${gSysVer:0:5} in
# 10.8|10.8. ) gSysName="Mountain Lion"
# gSysFolder=/kexts/10.8
# ;;
10.9|10.9. ) gSysName="Mavericks"
gSysFolder=/kexts/10.9
;;
10.10 ) gSysName="Yosemite"
gSysFolder=/kexts/10.10
;;
* ) echo "OS X Version: $gSysVer is not supported"
echo "No system files were changed"
echo "To save a Copy to this Terminal session: Terminal/Shell/Export Text As ..."
exit 1
;;
esac

echo "$gFile"
sudo cp -R $gExtensionsDirectory/AppleHDA.kext $gDesktopDirectory/AppleHDA-orig.kext

echo
echo "Patch binary ..."

case $gSysVer in

10.10|10.10.1|10.10.2|10.10.3|10.10.4|10.10.5 )
echo "$gSysVer controller patch"
# HD4600/0c0c HDMI audio patch (10.10)
sudo xxd -ps $gHDAControllerbinaryDirectory/AppleHDAController | tr -d '\n' > /tmp/AppleHDAController.txt
sudo /usr/bin/perl -pi -e 's|3d0c0a0000740e|3d0c0c0000740e|g' /tmp/AppleHDAController.txt
sudo /usr/bin/perl -pi -e 's|3d0c0a00000f84|3d0c0c00000f84|g' /tmp/AppleHDAController.txt
sudo /usr/bin/perl -pi -e 's|3d0c0a00000f8520010000|3d0c0c0000744b90909090|g' /tmp/AppleHDAController.txt  # dp5
# sudo /usr/bin/perl -pi -e 's|3d0c0c00000f8496000000|3d0c0c0000744b90909090|g' /tmp/AppleHDAController.txt  # dp1/dp2/dp3/dp4
sudo xxd -r -p /tmp/AppleHDAController.txt $gHDAControllerbinaryDirectory/AppleHDAController
sudo rm -R /tmp/AppleHDAController.txt
;;

10.9|10.9.1|10.9.2|10.9.3|10.9.4|10.9.5 )
echo "$gSysVer controller patch"
# HD4600/0c0c HDMI audio patch (10.9)
sudo xxd -ps $gHDAControllerbinaryDirectory/AppleHDAController | tr -d '\n' > /tmp/AppleHDAController.txt
sudo /usr/bin/perl -pi -e 's|0b0c0000|0c0c0000|g' /tmp/AppleHDAController.txt
sudo /usr/bin/perl -pi -e 's|0c0a0000|0c0c0000|g' /tmp/AppleHDAController.txt
sudo xxd -r -p /tmp/AppleHDAController.txt $gHDAControllerbinaryDirectory/AppleHDAController
sudo rm -R /tmp/AppleHDAController.txt
;;

* ) echo "OS X Version: $gSysVer does not support HD46000 HDMI audio"
echo "No system files were changed"
echo "To save a copy of this Terminal session: Terminal/Shell/Export Text As ..."
exit 1
;;
esac

# exit if error
if [ "$?" != "0" ]; then
echo "Error: $gCodec  controller patch failure"
sudo rm -fR $gExtensionsDirectory/AppleHDA.kext
sudo cp -R $gDesktopDirectory/AppleHDA-orig.kext $gExtensionsDirectory/AppleHDA.kext
sudo chown -R root:wheel $gExtensionsDirectory/AppleHDA.kext
sudo touch $gExtensionsDirectory
echo "Original S/L/E/AppleHDA.kext restored"
echo "To save a copy of this Terminal session: Terminal/Shell/Export Text As ..."
exit 1
fi

case $gSysName in
"Yosemite" )
echo "Fix permissions ..."
sudo chown -R root:wheel $gExtensionsDirectory/AppleHDA.kext
echo "Kernel cache..."
sudo touch $gExtensionsDirectory
sudo kextcache -Boot -U /
;;

"Mavericks"|"Mountain Lion" )
echo "Fix permissions ..."
sudo chown -R root:wheel $gExtensionsDirectory/AppleHDA.kext
echo "Kernel cache..."
sudo touch $gExtensionsDirectory
echo "Allow a few minutes for kernel cache rebuild."
;;
esac

# exit if error
if [ "$?" != "0" ]; then
echo Error: Maintenance failure
echo "Verify Permissions"
echo "Rebuild Kernel Cache"
echo "Verify S/L/E/AppleHDA.kext"
echo "To save a Copy to this Terminal session: Terminal/Shell/Export Text As ..."
exit 1
fi

echo "To save a Copy to this Terminal session: Terminal/Shell/Export Text As ..."
echo "Install finished, restart required."
exit