// Patch by anonymous writer
// www.hackintosh-forum.de
//
// GPIO ASUS for ZENBOOK UX330UAK
//
// The following clover patches are additionally required
//
//				<dict>
//					<key>Comment</key>
//					<string>change Method(_STA,0,NS) in GPI0 to XSTA</string>
//					<key>Disabled</key>
//					<false/>
//					<key>Find</key>
//					<data>
//					X1NUQQCgCZNTQlJH
//					</data>
//					<key>Replace</key>
//					<data>
//					WFNUQQCgCZNTQlJH
//					</data>
//				</dict>
//				<dict>
//					<key>Comment</key>
//					<string>change Method(_CRS,0,S) in ETPD to XCRS</string>
//					<key>Disabled</key>
//					<false/>
//					<key>Find</key>
//					<data>
//					X0NSUwgIU0JGSQ==
//					</data>
//					<key>Replace</key>
//					<data>
//					WENSUwgIU0JGSQ==
//					</data>
//				</dict>
//
DefinitionBlock ("GPIO", "SSDT", 2, "hack", "elan", 0x00000000)
{    
    // replace Method(_STA,0,S) in Device(GPI0)
    External(_SB.PCI0.GPI0, DeviceObj)
    Method (_SB.PCI0.GPI0._STA, 0, NotSerialized)
    {
        Return (0x0F)
    }
    
    // GPIO Pin for ETPD
    External(_SB.PCI0.I2C1.ETPD, DeviceObj)
    Scope (_SB.PCI0.I2C1.ETPD)
    {
        Name (SBFG, ResourceTemplate ()
        {
            GpioInt (Level, ActiveLow, ExclusiveAndWake, PullDefault, 0x0000,
                "\\_SB.PCI0.GPI0", 0x00, ResourceConsumer, ,
                )
                {
                    0x51 // Custom pin here
                }
        })
        Method (_CRS, 0, Serialized)
        {
            Name (SBFB, ResourceTemplate ()
            {
                I2cSerialBusV2 (0x0015, ControllerInitiated, 0x00061A80,
                    AddressingMode7Bit, "\\_SB.PCI0.I2C1",
                    0x00, ResourceConsumer, , Exclusive,
                    )
            })
            Return (ConcatenateResTemplate (SBFB, SBFG))
        }
    }
}