DefinitionBlock("", "SSDT", 2, "hack", "batt", 0)
{
    
    External (_SB_.PCI0.LPC, DeviceObj)    // 1 Arguments (from opcode)
    External (_SB_.PCI0.LPC.EC, DeviceObj)    // 1 Arguments (from opcode)
    External (_SB_.PCI0.LPC.EC.HSPD, FieldUnitObj)    // 1 Arguments (from opcode)
    External (_SB_.PCI0.LPC.EC.TMP0, FieldUnitObj)    // 1 Arguments (from opcode)
    External (_SB_.PCI0.LPC_.KBD_, DeviceObj)    // (from opcode)

            // ------------ EC
    External (BATM, MutexObj)    // (from opcode)
    External (HIID, FieldUnitObj)    // (from opcode)    
    External (_SB_.PCI0.XHC.PR2, FieldUnitObj)    // (from opcode)
    External (_SB_.PCI0.XHC.PR2M, FieldUnitObj)    // (from opcode)
    External (_SB_.PCI0.XHC.PR3, FieldUnitObj)    // (from opcode)
    External (_SB_.PCI0.XHC.PR3M, FieldUnitObj)    // (from opcode)
    External (_SB_.PCI0.XHC.XRST, FieldUnitObj)    // (from opcode)
    
    External (_SB_.PCI0.IGPU.GLIS, MethodObj)    // 1 Arguments (from opcode)
    External (_SB_.PCI0.IGPU.STAT, FieldUnitObj)    // (from opcode)
    External (_SB_.PCI0.IGPU.TCHE, MethodObj)    // 0 Arguments (from opcode)
    External (_SB_.PCI0.IGPU.VRSI, MethodObj)    // 0 Arguments (from opcode)
    
    External (_SB_.IAOE.GAOS, MethodObj)    // 0 Arguments (from opcode)
    External (_SB_.IAOE.GSWR, MethodObj)    // 0 Arguments (from opcode)
    
    External (_SB_.LID_, DeviceObj)    // (from opcode)
    External (_SB_.LID_._LID, MethodObj)    // 0 Arguments (from opcode)
    
    External (_SB_.SLPB, DeviceObj)    // (from opcode)
    External (_SI_._SST, MethodObj)    // 1 Arguments (from opcode)
    External (_TZ_.THM0, ThermalZoneObj)    // (from opcode)
    
    External (UCMS, MethodObj)
    External (CSUM, MethodObj)    // 1 Arguments (from opcode)
    External (PNTF, MethodObj)    // 1 Arguments (from opcode)
    External (NVSS, MethodObj)    // 1 Arguments (from opcode)
    External (VBTD, MethodObj)    // 0 Arguments (from opcode)
    External (VSLD, MethodObj)    // 1 Arguments (from opcode)
    External (VCMS, MethodObj)    // 2 Arguments (from opcode)
    External (AWON, MethodObj)    // 1 Arguments (from opcode)
    External (VBRC, MethodObj)    // 1 Arguments (from opcode)
    
    External (XHC, FieldUnitObj)    // (from opcode)
    External (SPS, FieldUnitObj)    // (from opcode)
    External (LIDB, FieldUnitObj)
    External (FNID, FieldUnitObj)
    External (CHKC, FieldUnitObj)    // (from opcode)
    External (CHKE, FieldUnitObj)    // (from opcode)
    External (CMPR, FieldUnitObj)    // (from opcode)
    External (MTAU, FieldUnitObj)    // (from opcode)
    External (OSC4, FieldUnitObj)    // (from opcode)
    External (RRBF, FieldUnitObj)    // (from opcode)
    External (PWRS, FieldUnitObj)    // (from opcode)
    External (WVIS, FieldUnitObj)    // (from opcode)
    External (VIGD, FieldUnitObj)    // (from opcode)
    External (IOEN, FieldUnitObj)    // (from opcode)
    External (IOST, FieldUnitObj)    // (from opcode)
    External (ISCT, FieldUnitObj)    // (from opcode)
    External (ISWK, FieldUnitObj)    // (from opcode)
    External (PL1L, FieldUnitObj)    // (from opcode)
    External (PL1M, FieldUnitObj)    // (from opcode)
    External (ACST, FieldUnitObj)    // (from opcode)
    External (SCRM, FieldUnitObj)    // (from opcode)
    External (USBR, FieldUnitObj)    // (from opcode)
    External (BRLV, FieldUnitObj)    // (from opcode)
    External (NBCF, FieldUnitObj)    // (from opcode)
    
    External (WAKI)

            // --------- BATC    
    External (_SB_.PCI0.LPC_.EC__.BAT0, DeviceObj)    // (from opcode)
    External (_SB_.PCI0.LPC_.EC__.BAT0._BIF, MethodObj)    // 0 Arguments (from opcode)
    External (_SB_.PCI0.LPC_.EC__.BAT0._BST, MethodObj)    // 0 Arguments (from opcode)
    External (_SB_.PCI0.LPC_.EC__.BAT0._HID, IntObj)    // (from opcode)
    External (_SB_.PCI0.LPC_.EC__.BAT0._STA, MethodObj)    // 0 Arguments (from opcode)
    External (_SB_.PCI0.LPC_.EC__.BAT1, DeviceObj)    // (from opcode)
    External (_SB_.PCI0.LPC_.EC__.BAT1._BIF, MethodObj)    // 0 Arguments (from opcode)
    External (_SB_.PCI0.LPC_.EC__.BAT1._BST, MethodObj)    // 0 Arguments (from opcode)
    External (_SB_.PCI0.LPC_.EC__.BAT1._HID, IntObj)    // (from opcode)
    External (_SB_.PCI0.LPC_.EC__.BAT1._STA, MethodObj)    // 0 Arguments (from opcode)
    
        // ------------ WAK:
    External (_SB_.PCI0.LPC.EC.HCMU, FieldUnitObj)
    External (_SB_.PCI0.LPC.EC.EVNT, MethodObj)
    External (_SB_.PCI0.LPC.EC.FNST, MethodObj)
    External (_SB_.PCI0.LPC.EC.HFNI, MethodObj)
    External (_SB_.PCI0.LPC.EC.ATMC, MethodObj)
    External (_SB_.PCI0.LPC.EC.HFSP, FieldUnitObj)
    External (_SB_.PCI0.LPC.EC.PLTU, FieldUnitObj)
    External (_SB_.PCI0.LPC.EC.PLLS, FieldUnitObj)
    External (_SB_.PCI0.LPC.EC.PLMS, FieldUnitObj)
    External (_SB_.PCI0.LPC.EC.PLSL, FieldUnitObj)
    External (_SB_.PCI0.LPC.EC.PIBS, FieldUnitObj)
    External (_SB_.PCI0.LPC.EC.SKEM, FieldUnitObj)
    External (_SB_.PCI0.LPC.EC.HSPA, FieldUnitObj)
    External (_SB_.PCI0.LPC.EC.BRNS, MethodObj)
    External (_SB_.PCI0.LPC.EC.BATW, MethodObj)
    External (_SB_.PCI0.LPC.EC.HKEY.DHKC, MethodObj)    // 0 Arguments (from opcode)
    External (_SB_.PCI0.LPC.EC.HKEY.MHKE, MethodObj)    // 1 Arguments (from opcode)
    External (_SB_.PCI0.LPC.EC.HKEY.MHKQ, MethodObj)    // 1 Arguments (from opcode)
    External (_SB_.PCI0.LPC.EC.HKEY.WGWK, MethodObj)    // 1 Arguments (from opcode)
    External (_SB_.PCI0.LPC.EC.AC._PSR, MethodObj)
        // -------------- helligkeitsregelung:    
    External (KBD_, UnknownObj)    // (from opcode)

/*
 T440s - batterieanzeige
 Methoden zum wiederzusammenfassen der gesplitteten Felder,
 EC-device parts mit Feldern groesser 8bit (aufgesplittet)
 EC-device parts in denen gesplittete Felder gelesen/geschrieben werden (GBIF,GBST, sowie _WAK)
 Q14,Q15 fuer helligkeitsanzeige per fn/taste
*/    
    Method (B1B2, 2, NotSerialized)
    {
        Return (Or (Arg0, ShiftLeft (Arg1, 0x08)))
    }

    Method (B1B4, 4, NotSerialized)
    {
        Store (Arg3, Local0)
        Or (Arg2, ShiftLeft (Local0, 0x08), Local0)
        Or (Arg1, ShiftLeft (Local0, 0x08), Local0)
        Or (Arg0, ShiftLeft (Local0, 0x08), Local0)
        Return (Local0)
    }
    
    Method (L1L4, 4, NotSerialized)
    {
        Or (ShiftLeft (Arg1, 0x20), Arg0, Local0)
        Or (ShiftLeft (Arg2, 0x40), Local0, Local0)
        Or (ShiftLeft (Arg3, 0x60), Local0, Local0)
        Return (Local0)
    }
    
    Scope (_SB.PCI0.LPC)
    {
        OperationRegion (RMP1, PCI_Config, 0xF0, 0x04)
        Field (RMP1, DWordAcc, NoLock, Preserve)
        {
            RCB3,   32
        }

        OperationRegion (FDM1, SystemMemory, Add (And (RCB3, 0xFFFFFFFFFFFFC000), 0x3418), 0x04)
        Field (FDM1, DWordAcc, NoLock, Preserve)
        {
                ,   15, 
            FDE1,   1
        }

        Device (SMCD)
        {
            Name (_HID, "MON0000")  // _HID: Hardware ID
            Method (FAN0, 0, NotSerialized)
            {
                //Store (^^EC.HSPD, Local0)
                Store (B1B2 (^^EC.HSP0, ^^EC.HSP1), Local0)
                Return (Local0)
            }

            Method (TCPU, 0, NotSerialized)
            {
                Store (^^EC.TMP0, Local0)
                Return (Local0)
            }
        }
    }
    
    Scope(_SB.PCI0.LPC.EC)
    {        
        OperationRegion (ECR1, EmbeddedControl, Zero, 0x0100)
        Field (ECR1, ByteAcc, NoLock, Preserve)
        {
            Offset (0x36), 
            HWA0,   8,    //HWAC - _WAK
            HWA1,   8,  
            Offset (0x84), 
            HSP0,   8,    //HSPD - SMCD 
            HSP1,   8
        }
        
        Field (ECR1, ByteAcc, NoLock, Preserve)
        {
            Offset (0xA0), 
            SBR0,   8,    //SBRC - GBIF 
            SBR1,   8, 
            SBF0,   8,    //SBFC - GBST
            SBF1,   8, 
            Offset (0xA8), 
            SBA0,   8,    //SBAC - GBST
            SBA1,   8, 
            SBV0,   8,    //SBVO - GBST 
            SBV1,   8
        }
        
        Field (ECR1, ByteAcc, NoLock, Preserve)
        {
            Offset (0xA0), 
            SBB0,   8,    //SBBM - GBIF 
            SBB1,   8, 
        }
        
        Field (ECR1, ByteAcc, NoLock, Preserve)
        {
            Offset (0xA0), 
            SBD0,   8,    //SBDC - GBIF 
            SBD1,   8, 
            BDV0,   8,    //SBDV - GBIF 
            BDV1,   8, 
            Offset (0xAA), 
            SBS0,   8,    //SBSN - GBIF 
            SBS1,   8
        }
        
        Field (ECR1, ByteAcc, NoLock, Preserve)
        {
            Offset (0xA0), 
            SBC0,   8,    //SBCH - GBIF 
            SBC1,   8, 
            SBC2,   8, 
            SBC3,   8
        }
        
        Field (ECR1, ByteAcc, NoLock, Preserve)
        {
            Offset (0xA0), 
            //SBMN,   128    // GBIF
            BMN0, 8, 
            BMN1, 8, 
            BMN2, 8, 
            BMN3, 8, 
            BMN4, 8, 
            BMN5, 8, 
            BMN6, 8, 
            BMN7, 8, 
            BMN8, 8, 
            BMN9, 8, 
            BMNA, 8, 
            BMNB, 8, 
            BMNC, 8, 
            BMND, 8, 
            BMNE, 8, 
            BMNF, 8
        }

        Field (ECR1, ByteAcc, NoLock, Preserve)
        {
            Offset (0xA0), 
            //SBDN,   128    // GBIF
            BDN0, 8, 
            BDN1, 8, 
            BDN2, 8, 
            BDN3, 8, 
            BDN4, 8, 
            BDN5, 8, 
            BDN6, 8, 
            BDN7, 8, 
            BDN8, 8, 
            BDN9, 8, 
            BDNA, 8, 
            BDNB, 8, 
            BDNC, 8, 
            BDND, 8, 
            BDNE, 8, 
            BDNF, 8
        }
        
        Method (GBIF, 3, NotSerialized)
        {
            Acquire (BATM, 0xFFFF)
            If (Arg2)
            {
                Or (Arg0, 0x01, HIID)
                //Store (SBBM, Local7)
                Store (B1B2(SBB0, SBB1), Local7)
                ShiftRight (Local7, 0x0F, Local7)
                XOr (Local7, 0x01, Index (Arg1, 0x00))
                Store (Arg0, HIID)
                If (Local7)
                {
                    //Multiply (SBFC, 0x0A, Local1)
                    Multiply (B1B2(SBF0, SBF1), 0x0A, Local1)
                }
                Else
                {
                    //Store (SBFC, Local1)
                    Store (B1B2(SBF0, SBF1), Local1)
                }

                Store (Local1, Index (Arg1, 0x02))
                Or (Arg0, 0x02, HIID)
                If (Local7)
                {
                    //Multiply (SBDC, 0x0A, Local0)
                    Multiply (B1B2(SBD0, SBD1), 0x0A, Local0)
                }
                Else
                {
                    //Store (SBDC, Local0)
                    Store (B1B2(SBD0, SBD1), Local0)
                }

                Store (Local0, Index (Arg1, 0x01))
                Divide (Local1, 0x14, Local2, Index (Arg1, 0x05))
                If (Local7)
                {
                    Store (0xC8, Index (Arg1, 0x06))
                }
                //ElseIf (SBDV)
                ElseIf (B1B2(BDV0, BDV1))
                {
                    //Divide (0x00030D40, SBDV, Local2, Index (Arg1, 0x06))
                    Divide (0x00030D40, B1B2(BDV0, BDV1), Local2, Index (Arg1, 0x06))
                }
                Else
                {
                    Store (0x00, Index (Arg1, 0x06))
                }

                //Store (SBDV, Index (Arg1, 0x04))
                Store (B1B2(BDV0, BDV1), Index (Arg1, 0x04))
                //Store (SBSN, Local0)
                Store (B1B2(SBS0, SBS1), Local0)
                Name (SERN, Buffer (0x06)
                {
                    "     "
                })
                Store (0x04, Local2)
                While (Local0)
                {
                    Divide (Local0, 0x0A, Local1, Local0)
                    Add (Local1, 0x30, Index (SERN, Local2))
                    Decrement (Local2)
                }

                Store (SERN, Index (Arg1, 0x0A))
                Or (Arg0, 0x06, HIID)
                //Store (SBDN, Index (Arg1, 0x09))
                Store (L1L4 (
		            B1B4 (BDN0, BDN1, BDN2, BDN3), 
		            B1B4 (BDN4, BDN5, BDN6, BDN7), 
		            B1B4 (BDN8, BDN9, BDNA, BDNB), 
		            B1B4 (BDNC, BDND, BDNE, BDNF)
	            ), Index (Arg1, 0x09))
                Or (Arg0, 0x04, HIID)
                Name (BTYP, Buffer (0x05)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00                   
                })
                //Store (SBCH, BTYP)
                Store (B1B4(SBC0, SBC1, SBC2, SBC3), BTYP)
                Store (BTYP, Index (Arg1, 0x0B))
                Or (Arg0, 0x05, HIID)
                //Store (SBMN, Index (Arg1, 0x0C))
                Store (L1L4 (
		            B1B4 (BMN0, BMN1, BMN2, BMN3), 
		            B1B4 (BMN4, BMN5, BMN6, BMN7), 
		            B1B4 (BMN8, BMN9, BMNA, BMNB), 
		            B1B4 (BMNC, BMND, BMNE, BMNF)
	            ), Index (Arg1, 0x0C))
            }
            Else
            {
                Store (0xFFFFFFFF, Index (Arg1, 0x01))
                Store (0x00, Index (Arg1, 0x05))
                Store (0x00, Index (Arg1, 0x06))
                Store (0xFFFFFFFF, Index (Arg1, 0x02))
            }

            Release (BATM)
            Return (Arg1)
        }
        
        Method (GBST, 4, NotSerialized)
        {
            Acquire (BATM, 0xFFFF)
            If (And (Arg1, 0x20))
            {
                Store (0x02, Local0)
            }
            ElseIf (And (Arg1, 0x40))
            {
                Store (0x01, Local0)
            }
            Else
            {
                Store (0x00, Local0)
            }

            If (And (Arg1, 0x07)) {}
            Else
            {
                Or (Local0, 0x04, Local0)
            }

            If (LEqual (And (Arg1, 0x07), 0x07))
            {
                Store (0x04, Local0)
                Store (0x00, Local1)
                Store (0x00, Local2)
                Store (0x00, Local3)
            }
            Else
            {
                Store (Arg0, HIID)
                //Store (SBVO, Local3)
                Store (B1B2(SBV0, SBV1), Local3)
                If (Arg2)
                {
                    //Multiply (SBRC, 0x0A, Local2)
                    Multiply (B1B2(SBR0, SBR1), 0x0A, Local2)
                }
                Else
                {
                    //Store (SBRC, Local2)
                    Store (B1B2(SBR0, SBR1), Local2)
                }

                //Store (SBAC, Local1)
                Store (B1B2(SBA0, SBA1), Local1)
                If (LGreaterEqual (Local1, 0x8000))
                {
                    If (And (Local0, 0x01))
                    {
                        Subtract (0x00010000, Local1, Local1)
                    }
                    Else
                    {
                        Store (0x00, Local1)
                    }
                }
                ElseIf (LNot (And (Local0, 0x02)))
                {
                    Store (0x00, Local1)
                }

                If (Arg2)
                {
                    Multiply (Local3, Local1, Local1)
                    Divide (Local1, 0x03E8, Local7, Local1)
                    And (Local7, Ones, Local7)
                }
                Store (Local0, Index (Arg3, 0x00))
                Store (Local1, Index (Arg3, 0x01))
                Store (Local2, Index (Arg3, 0x02))
                Store (Local3, Index (Arg3, 0x03))
                Release (BATM)
                Return (Arg3)
            }
            Return (Zero)
        }
/*        
        Device (BATC)
        {
            Name (_HID, EisaId ("PNP0C0A"))  // _HID: Hardware ID
            Name (_UID, 0x02)  // _UID: Unique ID
            Method (_INI, 0, NotSerialized)  // _INI: Initialize
            {
                Store (Zero, ^^BAT0._HID)
                Store (Zero, ^^BAT1._HID)
            }

            Method (CVWA, 3, NotSerialized)
            {
                If (Arg2)
                {
                    Divide (Multiply (Arg0, 0x03E8), Arg1, , Arg0)
                }

                Return (Arg0)
            }

            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                Return (Or (^^BAT0._STA (), ^^BAT1._STA ()))
            }

            Name (B0CO, Zero)
            Name (B1CO, Zero)
            Name (B0DV, Zero)
            Name (B1DV, Zero)
            Method (_BST, 0, NotSerialized)  // _BST: Battery Status
            {
                Store (^^BAT0._BST (), Local0)
                Store (^^BAT0._STA (), Local2)
                If (LEqual (0x1F, Local2))
                {
                    Store (DerefOf (Index (Local0, 0x02)), Local4)
                    If (LOr (LNot (Local4), LEqual (Ones, Local4)))
                    {
                        Store (Zero, Local2)
                    }
                }

                Store (^^BAT1._BST (), Local1)
                Store (^^BAT1._STA (), Local3)
                If (LEqual (0x1F, Local3))
                {
                    Store (DerefOf (Index (Local1, 0x02)), Local4)
                    If (LOr (LNot (Local4), LEqual (Ones, Local4)))
                    {
                        Store (Zero, Local3)
                    }
                }

                If (LAnd (LNotEqual (0x1F, Local2), LEqual (0x1F, Local3)))
                {
                    Store (Local1, Local0)
                    Store (Local3, Local2)
                    Store (Zero, Local3)
                }

                If (LAnd (LEqual (0x1F, Local2), LEqual (0x1F, Local3)))
                {
                    Store (DerefOf (Index (Local0, Zero)), Local4)
                    Store (DerefOf (Index (Local1, Zero)), Local5)
                    If (LOr (LEqual (Local4, 0x02), LEqual (Local5, 0x02)))
                    {
                        Store (0x02, Index (Local0, Zero))
                    }
                    ElseIf (LOr (LEqual (Local4, One), LEqual (Local5, One)))
                    {
                        Store (One, Index (Local0, Zero))
                    }
                    ElseIf (LOr (LEqual (Local4, 0x05), LEqual (Local5, 0x05)))
                    {
                        Store (0x05, Index (Local0, Zero))
                    }
                    ElseIf (LOr (LEqual (Local4, 0x04), LEqual (Local5, 0x04)))
                    {
                        Store (0x04, Index (Local0, Zero))
                    }

                    Add (CVWA (DerefOf (Index (Local0, One)), B0DV, B0CO), CVWA (DerefOf (Index (Local1, One)), B1DV, B1CO), Index (Local0, One))
                    Add (CVWA (DerefOf (Index (Local0, 0x02)), B0DV, B0CO), CVWA (DerefOf (Index (Local1, 0x02)), B1DV, B1CO), Index (Local0, 0x02))
                    Divide (Add (DerefOf (Index (Local0, 0x03)), DerefOf (Index (Local1, 0x03))), 0x02, , Index (Local0, 0x03))
                }

                Return (Local0)
            }

            Method (_BIF, 0, NotSerialized)  // _BIF: Battery Information
            {
                Store (^^BAT0._BIF (), Local0)
                Store (^^BAT0._STA (), Local2)
                If (LEqual (0x1F, Local2))
                {
                    Store (DerefOf (Index (Local0, One)), Local4)
                    If (LOr (LNot (Local4), LEqual (Ones, Local4)))
                    {
                        Store (Zero, Local2)
                    }

                    Store (DerefOf (Index (Local0, 0x02)), Local4)
                    If (LOr (LNot (Local4), LEqual (Ones, Local4)))
                    {
                        Store (Zero, Local2)
                    }

                    Store (DerefOf (Index (Local0, 0x04)), Local4)
                    If (LOr (LNot (Local4), LEqual (Ones, Local4)))
                    {
                        Store (Zero, Local2)
                    }
                }

                Store (^^BAT1._BIF (), Local1)
                Store (^^BAT1._STA (), Local3)
                If (LEqual (0x1F, Local3))
                {
                    Store (DerefOf (Index (Local1, One)), Local4)
                    If (LOr (LNot (Local4), LEqual (Ones, Local4)))
                    {
                        Store (Zero, Local3)
                    }

                    Store (DerefOf (Index (Local1, 0x02)), Local4)
                    If (LOr (LNot (Local4), LEqual (Ones, Local4)))
                    {
                        Store (Zero, Local3)
                    }

                    Store (DerefOf (Index (Local1, 0x04)), Local4)
                    If (LOr (LNot (Local4), LEqual (Ones, Local4)))
                    {
                        Store (Zero, Local3)
                    }
                }

                If (LAnd (LNotEqual (0x1F, Local2), LEqual (0x1F, Local3)))
                {
                    Store (Local1, Local0)
                    Store (Local3, Local2)
                    Store (Zero, Local3)
                }

                If (LAnd (LEqual (0x1F, Local2), LEqual (0x1F, Local3)))
                {
                    Store (LNot (DerefOf (Index (Local0, Zero))), B0CO)
                    Store (LNot (DerefOf (Index (Local1, Zero))), B1CO)
                    Store (One, Index (Local0, Zero))
                    Store (DerefOf (Index (Local0, 0x04)), B0DV)
                    Store (DerefOf (Index (Local1, 0x04)), B1DV)
                    Add (CVWA (DerefOf (Index (Local0, One)), B0DV, B0CO), CVWA (DerefOf (Index (Local1, One)), B1DV, B1CO), Index (Local0, One))
                    Add (CVWA (DerefOf (Index (Local0, 0x02)), B0DV, B0CO), CVWA (DerefOf (Index (Local1, 0x02)), B1DV, B1CO), Index (Local0, 0x02))
                    Divide (Add (B0DV, B1DV), 0x02, , Index (Local0, 0x04))
                    Add (CVWA (DerefOf (Index (Local0, 0x05)), B0DV, B0CO), CVWA (DerefOf (Index (Local1, 0x05)), B1DV, B1CO), Index (Local0, 0x05))
                    Add (CVWA (DerefOf (Index (Local0, 0x06)), B0DV, B0CO), CVWA (DerefOf (Index (Local1, 0x06)), B1DV, B1CO), Index (Local0, 0x06))
                }

                Return (Local0)
            }
        }
*/        
// helligkeitsregelung
        Method (_Q14, 0, NotSerialized)  // _Qxx: EC Query
        {
            Notify (KBD, 0x0406)
        }

        Method (_Q15, 0, NotSerialized)  // _Qxx: EC Query
        {
            Notify (KBD, 0x0405)
        }            
    }
    
    Method (_WAK, 1, NotSerialized)  // _WAK: Wake
    {
/* old        If (LOr (LEqual (Arg0, Zero), LGreaterEqual (Arg0, 0x05)))
        {
            Return (WAKI)
        }
*/

//fix: fixes
// use SPS which was set in _PTS instead of OS value
        Store (\SPS, Arg0)
// added call to SST to reset LEDs after sleep -- 2 is waking -- test: hier muss 0x01 statt 0x02, wenn kein SLPE!!
        \_SI._SST (0x01)

// check for arg0 value after sleep - this should not happen - but if not 0-5, then set to 4 (LID wake)
        If (LOr (LLess (Arg0, Zero), LGreater (Arg0, 0x05)))
        {
            Store (0x04, Arg0)
        }

        If (LOr (LEqual (Arg0, Zero), LGreaterEqual (Arg0, 0x05)))
        {
           
// added call to SST to reset LEDs after sleep -- 1 is normal
            \_SI._SST (One)
            Return (WAKI) /* \WAKI */
        }
//fixende

        Store (Zero, SPS)
        Store (Zero, \_SB.PCI0.LPC.EC.HCMU)
        \_SB.PCI0.LPC.EC.EVNT (One)
        \_SB.PCI0.LPC.EC.HKEY.MHKE (One)
        \_SB.PCI0.LPC.EC.FNST ()
        UCMS (0x0D)
        Store (Zero, LIDB)
        \_SB.PCI0.IGPU.VRSI ()
        If (LEqual (Arg0, One))
        {
            Store (\_SB.PCI0.LPC.EC.HFNI, FNID)
        }

        If (LEqual (Arg0, 0x03))
        {
            NVSS (Zero)
            Store (\_SB.PCI0.LPC.EC.AC._PSR (), PWRS)
            If (OSC4)
            {
                PNTF (0x81)
            }

            If (LNotEqual (ACST, \_SB.PCI0.LPC.EC.AC._PSR ()))
            {
                \_SB.PCI0.LPC.EC.ATMC ()
            }

            If (SCRM)
            {
                Store (0x07, \_SB.PCI0.LPC.EC.HFSP)
                If (MTAU)
                {
                    Store (0x03E8, Local2)
                    While (LAnd (\_SB.PCI0.LPC.EC.PIBS, Local2))
                    {
                        Sleep (One)
                        Decrement (Local2)
                    }

                    If (Local2)
                    {
                        Store (One, \_SB.PCI0.LPC.EC.PLSL)
                        Store (MTAU, \_SB.PCI0.LPC.EC.PLTU)
                        Store (PL1L, \_SB.PCI0.LPC.EC.PLLS)
                        Store (PL1M, \_SB.PCI0.LPC.EC.PLMS)
                    }
                }
            }

            Store (Zero, IOEN)
            Store (Zero, IOST)
            If (LEqual (ISWK, One))
            {
                If (\_SB.PCI0.LPC.EC.HKEY.DHKC)
                {
                    \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x6070)
                }
            }

            If (VIGD)
            {
                \_SB.PCI0.IGPU.GLIS (\_SB.LID._LID ())
                If (WVIS)
                {
                    VBTD ()
                }
            }
            ElseIf (WVIS)
            {
                \_SB.PCI0.IGPU.GLIS (\_SB.LID._LID ())
                VBTD ()
            }

//fix: eingefuegt notify..            
            Notify (\_SB.LID, 0x80)  // Having called IGD GLIS, signal the LID to wake
            VCMS (One, \_SB.LID._LID ())
            AWON (Zero)
            If (CMPR)
            {
                Notify (\_SB.SLPB, 0x02)
                Store (Zero, CMPR)
            }

            If (LOr (USBR, \_SB.PCI0.XHC.XRST))
            {
                If (LOr (LEqual (XHC, 0x02), LEqual (XHC, 0x03)))
                {
                    Store (Zero, Local0)
                    And (\_SB.PCI0.XHC.PR3, 0xFFFFFFC0, Local0)
                    Or (Local0, \_SB.PCI0.XHC.PR3M, \_SB.PCI0.XHC.PR3)
                    Store (Zero, Local0)
                    And (\_SB.PCI0.XHC.PR2, 0xFFFF8000, Local0)
                    Or (Local0, \_SB.PCI0.XHC.PR2M, \_SB.PCI0.XHC.PR2)
                }
            }

            If (LNotEqual (ISCT, Zero))
            {
                If (VIGD)
                {
                    If (And (\_SB.PCI0.IGPU.TCHE, 0x0100))
                    {
                        If (And (\_SB.IAOE.GAOS, One))
                        {
                            If (And (\_SB.IAOE.GSWR, 0x02))
                            {
                                Store (Or (And (\_SB.PCI0.IGPU.STAT, 0xFFFFFFFC), One), \_SB.PCI0.IGPU.STAT)
                                Store (One, \_SB.PCI0.LPC.EC.SKEM)
                            }
                        }
                    }
                }
            }
        }

        If (LEqual (Arg0, 0x04))
        {
            NVSS (Zero)
            Store (Zero, \_SB.PCI0.LPC.EC.HSPA)
            Store (\_SB.PCI0.LPC.EC.AC._PSR (), PWRS)
            If (OSC4)
            {
                PNTF (0x81)
            }

            \_SB.PCI0.LPC.EC.ATMC ()
            If (SCRM)
            {
                Store (0x07, \_SB.PCI0.LPC.EC.HFSP)
                If (MTAU)
                {
                    Store (0x03E8, Local2)
                    While (LAnd (\_SB.PCI0.LPC.EC.PIBS, Local2))
                    {
                        Sleep (One)
                        Decrement (Local2)
                    }

                    If (Local2)
                    {
                        Store (One, \_SB.PCI0.LPC.EC.PLSL)
                        Store (MTAU, \_SB.PCI0.LPC.EC.PLTU)
                        Store (PL1L, \_SB.PCI0.LPC.EC.PLLS)
                        Store (PL1M, \_SB.PCI0.LPC.EC.PLMS)
                    }
                }
            }

            If (LNot (NBCF))
            {
                If (VIGD)
                {
                    \_SB.PCI0.LPC.EC.BRNS ()
                }
                Else
                {
                    VBRC (BRLV)
                }
            }

            Store (Zero, IOEN)
            Store (Zero, IOST)
            If (LEqual (ISWK, 0x02))
            {
                If (\_SB.PCI0.LPC.EC.HKEY.DHKC)
                {
                    \_SB.PCI0.LPC.EC.HKEY.MHKQ (0x6080)
                }
            }

            If (\_SB.PCI0.XHC.XRST)
            {
                If (LOr (LEqual (XHC, 0x02), LEqual (XHC, 0x03)))
                {
                    Store (Zero, Local0)
                    And (\_SB.PCI0.XHC.PR3, 0xFFFFFFC0, Local0)
                    Or (Local0, \_SB.PCI0.XHC.PR3M, \_SB.PCI0.XHC.PR3)
                    Store (Zero, Local0)
                    And (\_SB.PCI0.XHC.PR2, 0xFFFF8000, Local0)
                    Or (Local0, \_SB.PCI0.XHC.PR2M, \_SB.PCI0.XHC.PR2)
                }
            }
        }

        \_SB.PCI0.LPC.EC.BATW (Arg0)
        \_SB.PCI0.LPC.EC.HKEY.WGWK (Arg0)
        Notify (\_TZ.THM0, 0x80)
        VSLD (\_SB.LID._LID ())
        If (VIGD)
        {
            \_SB.PCI0.IGPU.GLIS (\_SB.LID._LID ())
        }
        ElseIf (WVIS)
        {
            \_SB.PCI0.IGPU.GLIS (\_SB.LID._LID ())
        }

        If (LLess (Arg0, 0x04))
        {
//fix:            If (LOr (And (RRBF, 0x02), And (\_SB.PCI0.LPC.EC.HWAC, 0x02)))
            If (LOr (And (RRBF, 0x02), And (B1B2 (\_SB.PCI0.LPC.EC.HWA0, \_SB.PCI0.LPC.EC.HWA1), 0x02)))
            {
                ShiftLeft (Arg0, 0x08, Local0)
                Store (Or (0x2013, Local0), Local0)
                \_SB.PCI0.LPC.EC.HKEY.MHKQ (Local0)
            }
        }

        If (LEqual (Arg0, 0x04))
        {
            Store (Zero, Local0)
            Store (CSUM (Zero), Local1)
            If (LNotEqual (Local1, CHKC))
            {
                Store (One, Local0)
                Store (Local1, CHKC)
            }

            Store (CSUM (One), Local1)
            If (LNotEqual (Local1, CHKE))
            {
                Store (One, Local0)
                Store (Local1, CHKE)
            }

            If (Local0)
            {
                Notify (_SB, Zero)
            }
        }

//fix: added call to SST to reset LEDs after sleep -- value of 1 is normal
        \_SI._SST (One)
        Store (Zero, RRBF)
        Return (WAKI)
    }
}