# Changelog Gigabyte Z490 Vision G OpenCore

## 2021-11-
- Updated OpenCore to 0.7.6 nightly
- Updated `Drivers` and `Kexts`
- Tested with macOS Monterey 12.1
- **CONFIG**
	- Added Booter Patches to reroute Hardware Board-ID to OpenCore (disabled)
	- Added Kernel Patches for using VMM to spoof valid Board-ID to Update Servers via VMM (disabled) &rarr; might be useful when having issues wih updates. [**More info**](https://github.com/5T33Z0/OC-Little-Translated/tree/main/09_Board-ID_VMM-Spoof)
	- Changed `ResizeAppleGPBars` to `-1` → refer to Documentation.pdf if you want to configure it,
	- Added `SSDT-PMC.aml` &rarr; Adds PMCR device for macOS
	- Deleted `SSDT-PPMC.aml` &rarr; for 100/200 Series only.
- **KEXTs**:
	- Disabled `RestricEvents.kext` &rarr; no longer required for Updates (supposedly)

## 2021-10-26
- Updated OpenCore to 0.7.5 nightly
- Updated `Drivers` and `Kexts`
- Tested with macOS Monterey 12.0.1
- **ACPI**
	- Updated `SSDT-PORTS.aml` to conform to ACPI specs
- **CONFIG**
	- Updated configs to reflect latest OpenCore feature-set
	- changed `csr-active-config` to `67080000` so future update notifications work.
- **KEXTs**:
	- Removed `AGPMEnabler.kext` → no longer required. AGPMController works without it
	- Removed `USBPorts` → no longer needed. Ports are mapped via `SSDT-PORTS.aml`

**NOTE**: Check `ReadMe.md` for more information and getting the Intel® I225-V Ethernet Controller working on various versions of macOS.

<details>
<summary><strong>Old Changelogs</strong> (Click to expand)</summary>

## 2021-10-13
- Updated OpenCore to 0.7.5 nightly
- Updated BIOS to `F21a` → Updates PTT Support for Windows 11
- Updated `Drivers` and `Kexts`
- **ACPI**
	- Added `SSDT-PORTS.aml` with new Port Mapping → Replaces OEMTableID `xh_cmsd4` (SSDT-7-xh_cmsd4.aml), so `USBPorts.kext` is no longer required!
- **CONFIG**
	- Updated configs to reflect latest OpenCore feature-set 
	- `ACPI\Delete`: Added rule for dropping OEM XHCI Table `SSDT-7-xh_cmsd4.aml`
	- Changed `ResizeAppleGPBars` form `-1` to `10` Details [here](https://github.com/5T33Z0/OC-Little-Translated/tree/main/12_PCI_BAR_Size)

**NOTE**: Check `ReadMe.md` for more information and getting the Intel® I225-V Ethernet Controller working on various versions of macOS.

## 2021-10-03
- Updated OpenCore to 0.7.4 Release
- Updated `Drivers` and `Kexts`
- **CONFIG**
	- Updated configs to reflect latest OpenCore feature-set 
	- Changed `ConsoleMode` from `Max` to blank → Recommended Setting
	- Updated `MinKernel` and `MaxKernel` entries
	- Enabled `ResetLogoStatus` → New Default in `sample.plist`
	- Changed `ResizeAppleGPBars` form `-1` to `10`
- **KEXTS**
	- Added `NVMeFix.kext` → Recommended for all NVMe SSDs to fix power consumption.
	- Added `RestrictEvents.kext` → Adds macOS 12 software update support for any Mac model

**NOTE**: Check `ReadMe.md` for more information and getting the Intel® I225-V Ethernet Controller working on various versions of macOS. 

## 2021-09-07
- Updated OpenCore to 0.7.3 Release
- Updated `Drivers`, `Kexts` and `Resources`
- **CONFIG**:
	- Updated `config.plist` to reflect latest OpenCore feature-set 
	- Updated `UEFI` > `Drivers` Section to new format (see `sample.plist` for reference)
	- Added `SecureBootModel` entries for `iMac20,1` and `iMac20,2` (commented-out). Default is `Disabled`. Read "Strengthen Security" Section of the Repo for more Details. 
	- Added `ScanPolicy` values for hiding EFI Folders and NTFS Drives from Boot Picker (commented-out)
	- Changed `csr-active-config` to `67080000` for macOS Big Sur/Monterey. → disables SIP for everything but the BaseSystem.
	- Changed `PickerAttributes` from `16` to `145` to fully support custom Boot Picker icon sets
- **RESOURCES**:
	- Added 2 custom Boot Picker icon sets by [chris1111](https://github.com/chris1111/My-Simple-OC-Themes): "Minimal" and "Minimal-SSD". Change `PickerVariant` to either `chris1111\Minimal` or `chris1111\Minimal-SSD` to apply them (check "Flavors" Folder for Screenshots).

**NOTE**: Check `ReadMe.md` for more information and getting the Intel® I225-V Ethernet Controller working on various versions of macOS. 

## 2021-08-23
- Updated OpenCore to 0.7.3 Nightly
- Updated `Drivers` and `Kexts`
- **CONFIG**:
	- Updated `config.plist` to reflect latest OpenCore Feature-Set
	- Added `config_iMac19,1.plist` for running macOS 10.14 Mojave (last macOS with 32 Bit Support)
	- Updated `MinKernel` and `MaxKernel` Sections.
	- Disabled `ExternalDiskIcons` Quirk → no longer necessary
	- Changed `device-id`of Framebuffer Patches to `C59B0000` to match 10th Gen Intel CPUs.
	- Rearranged order of .aml files.
- **ACPI**:
	- Added `SSDT-PPMC.aml`again → reduces CPU idle frequencies significantly.
- **KEXTs**:
	- Added `SMCProcessor.kext` and `SMCSuperIO.kext` again to enable Fan/Pump speed and Board Logic monitoring. **NOTE**: You can disable these 2 Kexts if you have Intel(r) Power Gadget installed and enable its monitoring features in [HWMonitorSMC2](https://github.com/CloverHackyColor/HWMonitorSMC2) instead.
	- Added `USBPorts_iMac191.kext` for use with `iMac19,1` System Definition. **TIP**: if you use macOS Catalina or older, you could also use the `XHCIPortLimit` Quirk instead.
	- Renamed `USBPorts.kext` to `USBPorts_iMac202.kext` for use with iMac20,2. Since USBPort Kexts contain an info.plist which specifies the System Definition it is for you cannot use them globally for any SMBIOS. In other words: if you define your Hackintosh as `iMac19,1` → use `USBPorts_iMac191.kext`, if you define it as `iMac20,2` → use `USBPorts_iMac202.kext`. Here's a [list of the current port mapping](https://github.com/5T33Z0/Gigabyte-Z490-Vision-G-Hackintosh-OpenCore/blob/main/Additional%20Files/USB_Ports_List.pdf).

**NOTE**: Check `ReadMe.md` for more information and getting the Intel® I225-V Ethernet Controller working on various versions of macOS. 

## 2021-08-03
- Updated OpenCore to 0.7.2 Release Version
- Updated `Drivers` and `Kexts`
- Removed `SMCProcessor.kext` and `SMCSuperIO.kext`→ unnecessary for monitoring CPU Frequencies and Temps
- **ACPI**:
	- Updated .aml files based on latest ACPI Samples  
	- Removed `SSDT-DMAC.aml` and `SSDT-PPMC.aml` for now
- **Config**:
	- Updated `config.plist` to reflect the latest OpenCore feature-set
	- Kernel > Add: Updated `Arch` and `MinKernel` Sections
	- UEFI > APFS: Changed `MinDate` and `MinVersion` to `-1` → Disables the minimal date and version requirements for loading the APFS driver to maximize macOS compatibility. If these parameters are left at their default (`0`), your macOS partition will not show up in the Bootpicker unless macOS Big Sur or newer is installed since the APFS driver will not be loaded. </br> **CAUTION**: Once you've decided, which macOS version you are going to use, you *should* change the values for `MinDate` and `MinVersion` improved security. A List with values for macOS High Sierra up to Big Sur can be found [here](https://github.com/acidanthera/OpenCorePkg/blob/master/Include/Acidanthera/Library/OcApfsLib.h).

**IMPORTANT**: Follow instructions in the `Readme.md` to configure the Intel(r) I225-V Ethernet Controller for other macOS versions than macOS Big Sur 11.4+ to get working internet.

## 2021-07-04
- Updated OpenCore to latest 0.7.1 Release (build be2d9fe) 
- Made EFI Monterey Ready
- Updated `Drivers`, `Kexts` and `Resources`
- **Config**:
	- Updated `config.plist` to reflect latest OpenCore feature-set 
	- Updated `MinKernel` information in `Kernel` Section
	- Added `csr-active-config` value for macOS Monterey (commented-out)
	- Changed `SecureBootModel` from `j185f` to `Disabled` to avoid issues when trying to install/boot macOS Monterey 12 beta
	- Added `dk.e1000=0` to `boot-args` to avoid matching Intel's I225-V Ethernet Controller with the new default DEXT Driver `com.apple.DriverKit-AppleEthernetE1000`which can cause hangs on Gigabyte Boards.
	- `DeviceProperties`: disabled (commented-out) `PciRoot(0x0)/Pci(0x1C,0x1)/Pci(0x0,0x0)` → no longer necessary since `com.apple.driver.AppleIntelI210Ethernet` now supports the I225-V natively in macOS 11.4+. 
	- Set `MaxKernel` in Kernel > Patch > I225-V Patch to `20.4` so it only affects macOS Catalina and Big Sur up to version 11.3 → Catalina and Big Sur 11.3 have no native support for the I225-V Controller, so a different device ID has to be faked so the driver works. More details here: https://github.com/dortania/bugtracker/issues/213</br> 

**IMPORTANT**: Follow instructions in the `Readme.md` to configure the Intel(r) I225-V Ethernet Controller for other macOS versions than macOS Big Sur 11.4 to get working internet.

## 2021-06-12
- Updated OpenCore to the latest commit of 0.7.1 Nightly
- Updated `Drivers`, `Kexts` and `Resources`
- Fixes: Fix I225-V Ethernet Controller – works without FakePCIID kexts again for Catalina and Big Sur.
- **Config.plist**:
	- Updated `config.plist` to reflect latest OpenCore feature-set 
  	- Changed `PickerVariant` to `Acidanthera\GoldenGate`
	- Changed `DeviceProperties` > `PciRoot(0x0)/Pci(0x1C,0x1)/Pci(0x0,0x0)` > `device-id` to `F3158680` (Type: `Data`)→ Fixes Ethernet on Big Sur 11.4
	- Added `MinKernel` information to `Kernel` Section
- **KEXTS**:
	- Deleted `FakePCIID` and `FakePCIID_Intel_I225-V` → no longer necessary.

**IMPORTANT**: Follow instructions in `Readme.md` to configure I225-V Ethernet Controller for other macOS Versions to get working internet.

## 2021-06-07
- Updated OpenCore to 0.7.0 Release Version
- Updated `Drivers`, `Kexts` and `Resources`
- Updated `config.plist` to reflect latest OpenCore feature-set 
- Enabled `Security > AllowToggleSIP` to quickly enable/disable System Integrity Protection temporarily (press Spacebar in Bootpicker to access).

## 2021-05-25

- Updated OpenCore to the latest commit of 0.7.0
- Updated `Drivers` and `Resources`
- Reinstated **KEXTs** so Internet works (because [this Kernel Patch ](https://dortania.github.io/OpenCore-Install-Guide/config.plist/comet-lake.html#patch-2) does no longer work in macOS 11.4.):
	- `FakePCIID`
	- `FakePCIID_Intel_I225-V` 
- **CONFIG**:
	- Updated `config.plist` to reflect latest OpenCore feature-set 
	- Changed `PickerVariant` to `Auto` → Fixes Boot menu GUI
	- Disabled `Kernel > Patch > I225-V patch` since it currently doesn't work in macOS Big Sur 11.4

**NOTE**: User of macOS Big Sur 11.4 should use this EFI

## 2021-05-03

- Updated OpenCore to the latest v0.7.0 commit
- Updated `config.plist` to reflect latest OpenCore feature-set
- Updated `Drivers`& `Kexts`
- Deleted unused Framebuffer Patch from `DeviceProperties`
- Added correct `device-id` `C59B0000` for Intel(® i9 Cometlake CPUs to Framebuffer Patch

## 2021-04-19

- Updated OpenCore to latest v0.6.9 commit
- Updated `Drivers`
- Updated `Kexts` 
- Updated `config.plist` to reflect latest OpenCore feature set
- **ACPI**:
	- Updated `SSDT-SBUS-MCHC.aml` to latest version by Acidanthera
	- Removed `SSDT-MEM2`since it seems to be relevant to Laptop iGPUs only
- Deleted unnecessary **Kexts**:
	- `FakePCIID.kext` 
	- `FakePCIID_Intel_I225-V.kext`</br>
	- `FakePCIID_Intel_HDMI_Audio.kext`(never used it anyway)
- Added `Kernel` > `Patch` to natively support Intel® I225-V Ethernet-Controller 
- Changed `ExposeSensitiveData` to `7` to display OpenCore build version in BootPicker
</details>