# Z490 Vision G OpenCore Readme

### General Information

Follow the Instructions on my [Github Repo](https://github.com/5T33Z0/Gigabyte-Z490-Vision-G-Hackintosh-OpenCore) to use this EFI Folder and its `config.plist` correctly. 

The following Kexts are disabled by default since I don't know which CPU, GPU and hard disk type you will be using:

- `CPUFriend.kext` 
- `CPUFriendDataProvider.kext` – must be generated individually as well using [CPUFriendFriend](https://github.com/corpnewt/CPUFriendFriend). Follow the "Post-Install Tweaks" Section of the repo on how to do this.
- `NVMeFix.kext` – since I don't know if you are using a NVMe-SSD or not.

### Getting the Intel(R) I225-V Ethernet Controller to work in…

- …**macOS Monterey** (≥ 12.0.1):
	- Not working. It used to work between beta 7 and beta 9 and then it stopped. I have no hope for this beeing fixed.
	  
- …**macOS Big Sur** (≥ 11.4):
	
	1. Disable (comment-out) `DeviceProperties` > `PciRoot(0x0)/Pci(0x1C,0x1)/Pci(0x0,0x0)`
	2. Go to `Kernel` > `Patch` and disable `I225-V Patch`. Since this patch only applies to Darwin Kernels < 20.5, it won't affect Big Sur ≥ 11.4 anyway, so you might as well leave it enabled.
	3. Add boot-arg `dk.e1000=0`
	4. Save and reboot
	
	**NOTE**: This is the default configuration. If you are running Big Sur 11.4 you don't have to change anything here!
		
- …**macOS Catalina** and **Big Sur** (≤ macOS 11.3 ≤ Kernel 20.4):

	1. Enable (un-comment) `DeviceProperties` > `#PciRoot(0x0)/Pci(0x1C,0x1)/Pci(0x0,0x0)`
	2. Go to `Kernel` > `Patch` and enable `I225-V Patch`.
	3. Delete/disable boot-arg `dk.e1000=0`
	4. 	Save and reboot

- …**macOS Mojave** : I225-V Controller is not supported. You need an additional PCI Card.
	
**NOTE**: You could just leave the Device Property, Kernel Patch (since it will only apply up to Kernel 20.4 anyway) and boot-arg enabled for macOS Catalina, Big Sur/Monterey without causing issues. But I think it's cleaner to just enable what's necessary for each OS, unless you have a multiboot system with Catalina and Big Sur/Monterey installed. 

See this discussion for further details: https://github.com/dortania/bugtracker/issues/213

### Running a legacy macOS

#### Which macOS version to use?

If you want/need to run a legacy macOS on this board, **avoid High Sierra** because it changes something in the System Definition of the PreBoot Volume of Big Sur so it won't boot afterwards – even if you install it on a different Drive! After you've shut down High Sierra and want to boot back into Big Sur you will see the dreaded crossed out circle of death instead.

The only way to boot then is by adding `-no_compat_check` to boot-args. Next, you have to either perform some terminal wizardry or re-install Big Sur on top of your existing Install to fix it. You could say, "well, I just leave the -no_compat_check argument enabled then and carry on." You can do that, of course, but then you won't be getting System Updates.

Since macOS Mojave is the last macOS iteration with 32 bit support, I created a config for it.

#### About `config_iMac19,1.plist` 

This config is for installing and running your Hackintosh as an iMac19,1 so you are able to run legacy OSes such as macOS Mojave. The main difference to the primary config.plist are as follows:

- Uses SMBIOS for iMac19,1
- Emulates an i9-9900K Processor since Mojave doesn't support 10th Gen Intel CPUs (see Kernel > Emulate)
- Uses a different Framebuffer Patch and device-id, otherwise the boot is stalling 
- Internet is not working since 2.5 Gb Ethernet not supported before macOS Catalina.

**NOTE**: Although I created this config to be able to run a 32 bit supported version of macOS, it actually can boot everything from Mojave up to Monterey. I did some benchmarking test comparing result from iMac19,1 and iMac20,2 where iMac19,1 actually came out on top.
