# EFI Info
To make this EFI Folder work adjust add the correct config for your CPU as well as the corresponding SSDT files and you should have a working base config to boot your Hackintosh.

## Clover Version
- Clover r5148 (UEFI)
- CloverConfigPlistValidator. For validating your config.

## Enabled Drivers
- ApfsDriverLoader.efi
- OpenRuntime.efi
- VBoxHfs.efi

The rest of the drivers are located under `/drivers/off/UEFI`.  

## Included Kexts
The EFI Folder included in this repo comes with a minimal set of enabled kexts to get you started and make the system bootable.

### Enabled Kexts (in `Other` folder)
- [**AppleALC**](https://github.com/acidanthera/AppleALC)
- [**IntelMausi**](https://github.com/acidanthera/IntelMausi/releases) → Required for the majority of Intel NICs. If your board uses a different Ethernet Controller replace it by an Ethernet Kext from the "Off" folder
- [**Lilu**](https://github.com/acidanthera/Lilu/releases)
- [**RestrictEvents**](https://github.com/acidanthera/RestrictEvents/releases)
- [**VirtualSMC**](https://github.com/acidanthera/VirtualSMC/releases)
- [**WhateverGreen**](https://github.com/acidanthera/WhateverGreen/releases)

### Disabled Kexts (in `Off` folder)
- **For Ethernet**:
	- [**AtherosE2200Ethernet**](https://github.com/Mieze/AtherosE2200Ethernet/releases) → Required for Atheros and Killer NICs
	- [**LucyRTL8125Ethernet**](https://github.com/Mieze/LucyRTL8125Ethernet/releases) → For Realtek 2.5 Gbit Ethernet
	- [**RTL8111Ethernet**](https://github.com/Mieze/RTL8111_driver_for_OS_X/releases) → For Realtek Gigabit Ethernet
	- [**SmallTreeIntel82576**](https://github.com/khronokernel/SmallTree-I211-AT-patch/releases) → For I211 NICs, based on the SmallTree kext but patched to support I211
- **For USB Controllers**:
	- [**XHCI-unsupported.kext**](https://github.com/RehabMan/OS-X-USB-Inject-All) → Needed for non-native USB Controllers, such as: 
		- H370
		- B360
		- H310
		- Z390 (Not needed on Mojave and newer)
		- X79
		- X99
		- AsRock Boards (with Intel chipsets specifically, B460/Z490+ do not need it)
- [**NVMEfix**](https://github.com/acidanthera/NVMeFix/releases) → improves compatibility with non-Apple SSDs

### Other kexts (not included)
To find more Kexts you might need for your system and peripherals, read this in-depth explanation by Dortania about [Gathering Files](https://dortania.github.io/OpenCore-Install-Guide/ktext.html#kexts).
