#!/bin/sh
gDebug=0
# gCodecsinstalled
# gCodecVendor
# gCodecDevice
# gCodecName
# gCodec

# get installed codec/revision
gCodecsInstalled=$(ioreg -rxn IOHDACodecDevice | grep VendorID | awk '{ print $4 }' | sed -e 's/ffffffff//')
gCodecsVersion=$(ioreg -rxn IOHDACodecDevice | grep RevisionID| awk '{ print $4 }')

# debug
if [ $gDebug = 2 ]; then
# gCodecsInstalled=0x10ec0887
# gCodecsVersion=0x100101
# gCodecsVersion=0x100202
# gCodecsVersion=0x100302
# gCodecsInstalled=0x10ec0900
# gCodecsVersion=0x100001
# gCodecsInstalled=0x10134206
# gCodecsVersion=0x100302
    echo "gCodecsInstalled = $gCodecsInstalled"
    echo "gCodecsVersion = $gCodecsVersion"
fi

# no codecs detected
if [ -z "${gCodecsInstalled}" ]; then
    echo ""
    echo "No audio codec detected"
    echo "To save a Copy of this Terminal session: Terminal/Shell/Export Text As ..."
    exit 1
fi

# initialize variables
intel=n
amd=n
nvidia=n
realtek=n
unknown=n
alternate=n

# find realtek codecs
index=0
version=($gCodecsVersion)
for codec in $gCodecsInstalled
do

# debug
if [ $gDebug = 2 ]; then
    echo "Index = $index, Codec = $codec, Version = ${version[$index]}"
fi

# sort vendors and devices
case ${codec:2:4} in

    8086 ) Codecintelhdmi=$codec; intel=y
    ;;
    1002 ) Codecamdhdmi=$codec; amd=y
    ;;
    10de ) Codecnvidiahdmi=$codec; nvidia=y
    ;;
    10ec ) Codecrealtekaudio=$codec; Versionrealtekaudio=${version[$index]}; realtek=y
    ;;
    *) Codecunknownaudio=$codec; unknown=y
    ;;

esac
index=$((index + 1))
done

# special names
if [ $realtek = y ]; then
    gCodecVendor=${Codecrealtekaudio:2:4}
    gCodecDevice=${Codecrealtekaudio:6:4}

# debug
    if [ $gDebug = 2 ]; then
        echo "gCodecVendor = $gCodecVendor"
        echo "gCodecDevice = $gCodecDevice"
    fi

    if [ ${gCodecDevice:0:1} = 0 ]; then
        gCodecName=${gCodecDevice:1:3}
    fi

    if [ $gCodecDevice = "0899" ]; then
        gCodecName=898
    fi

    if [ $gCodecDevice = "0900" ]; then
        gCodecName=1150
    fi

# debug
if [ $gDebug = 2 ]; then
    echo "Codec identification: success"
fi

#  validate_realtek codec
    case "$gCodecName" in
    269|255|882|883|885|887|888|889|891|892|898|1150 )

# confirm codec, go button
    while true
    do
    read -p "Confirm Realtek ALC$gCodecName (y/n): " choice3
    case "$choice3" in
        [yY]* ) gCodec=$gCodecName; gCodecvalid=y; break;;
        [nN]* ) break;;
    * ) echo "Try again...";;
    esac
    done
    ;;

    * ) 
    ;;
    esac

fi
echo --------------------------------------------------------------------------------
echo "wait for Download to begin... "
if [ ${gCodecName} = 255 ]; then
	open -a Safari https://www.hackintosh-forum.de/index.php/Attachment/38217-AppleALC-255-zip/
fi

if [ ${gCodecName} = 882 ]; then
	open -a Safari https://www.hackintosh-forum.de/index.php/Attachment/38218-AppleALC-882-zip/
fi

if [ ${gCodecName} = 883 ]; then
	open -a Safari https://www.hackintosh-forum.de/index.php/Attachment/38219-AppleALC-883-zip/
fi

if [ ${gCodecName} = 885 ]; then
	open -a Safari https://www.hackintosh-forum.de/index.php/Attachment/38220-AppleALC-885-zip/
fi

if [ ${gCodecName} = 887 ]; then
	open -a Safari https://www.hackintosh-forum.de/index.php/Attachment/38221-AppleALC-887-zip/
fi	

if [ ${gCodecName} = 888 ]; then
	open -a Safari https://www.hackintosh-forum.de/index.php/Attachment/38222-AppleALC-888-zip/
fi

if [ ${gCodecName} = 889 ]; then
	open -a Safari https://www.hackintosh-forum.de/index.php/Attachment/38223-AppleALC-889-zip/
fi

if [ ${gCodecName} = 891 ]; then
	open -a Safari https://www.hackintosh-forum.de/index.php/Attachment/38224-AppleALC-891-zip/
fi

if [ ${gCodecName} = 892 ]; then
	open -a Safari https://www.hackintosh-forum.de/index.php/Attachment/38225-AppleALC-892-zip/
fi

if [ ${gCodecName} = 898 ]; then
	open -a Safari https://www.hackintosh-forum.de/index.php/Attachment/38226-AppleALC-898-zip/
fi

if [ ${gCodecName} = 1150 ]; then
	open -a Safari https://www.hackintosh-forum.de/index.php/Attachment/38227-AppleALC-1150-zip/
fi
echo --------------------------------------------------------------------------------