#!/bin/bash

dir=$( pwd )
OSXv=$( sw_vers -productVersion )
if [[ $OSXv == *"10.10"* ]]; then ver=10.10 ; fi
if [[ $OSXv == *"10.11"* ]]; then ver=10.11 ; fi
echo OS is: $OSXv

export PATH="/bin:/usr/bin:/usr/sbin"

vol="$@"
if [[ "$vol" == "" ]];
then
echo The target volume is: /
echo If target volume is not /, then start this script with the volume name as the script argument
echo Usage: $0 \"/Volume/Macintosh HD\"

dest="/Library/Extensions"
odest="/System/Library/Extensions"

else

echo The target volume is: $vol
export PATH="$PATH:$vol/bin:$vol/usr/bin:$vol/usr/sbin"
dest="$vol/Library/Extensions"
odest="$vol/System/Library/Extensions"
fi

orig=../kexts-orig

test -d $orig || sudo mkdir -p $orig
#
# install all kexts to $dest
#
echo Installing kexts in $dest
for kp in Other/*.kext ${ver}*/*.kext; 
do
k=${kp##*/}
echo "---------------- $k ----------------"
#remove old kexts
   if [ -e  $dest/$k ]; then sudo mv 	 "$dest/$k" $orig/${k}_1_$$ ;fi
   if [ -e $odest/$k ]; then sudo mv 	"$odest/$k" $orig/${k}_2_$$ ;fi
#copy new kext 
   sudo rsync -ar --delete $kp 		"$dest"
#fix owner and perms 
   sudo chown -R root:wheel 		"$dest/$k"
   sudo chmod -R go-w 			"$dest/$k"
done

# disable old kext - using IntelMausiEthernet now
echo "------------------------------------"
e=AppleIntelE1000e.kext
echo Looking for obsolete kext $e
if [ -e "$dest/IntelMausiEthernet.kext" ];
then
   if [ -e  "$dest/$e" ]; then sudo mv  "$dest/$e" "$dest/${e}.NU" ;fi
   if [ -e "$odest/$e" ]; then sudo mv "$odest/$e" "$dest/${e}.NU" ;fi
   if [ -e "$odest/IONetworkingFamily.kext/Contents/PlugIns/$e" ]; then sudo mv "$odest/IONetworkingFamily.kext/Contents/PlugIns/$e" "$dest/${e}.NU"; fi
fi

#fix sym links in wrapper kexts

cd "$dest/AppleHDA_20672.kext/Contents/MacOS"
sudo rm -rf AppleHDA
sudo ln -s /System/Library/Extensions/AppleHDA.kext/Contents/MacOS/AppleHDA

cd "$dest/BroadcomBluetooth_T420.kext/Contents/MacOS"
sudo rm -rf BroadcomBluetoothHostControllerUSBTransport
sudo ln -s /System/Library/Extensions/IOBluetoothFamily.kext/Contents/PlugIns/BroadcomBluetoothHostControllerUSBTransport.kext/Contents/MacOS/BroadcomBluetoothHostControllerUSBTransport

# report
cd $dir
echo 
m=$( shopt -s nullglob; echo $orig/* )
if [ "$m" != "" ]; then echo "Note: Previous/old kexts are here: $dir/$orig" ; fi
echo 
m=$( shopt -s nullglob; echo $odest/*.NU $dest/*.NU )
if [ "$m" != "" ]; then echo "Note: Obsolete/unused kexts are here: $m" ;fi

#wait for rebuild of cache
echo -n "sleeping for 20 seconds - wait … "
sleep 20

# rebuild kext caches one more time
sudo touch "$odest"
echo "… done!"
